<?php

use App\Http\Controllers\BuilderController;
use App\Http\Controllers\LegalController;
use App\Http\Controllers\MachineController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\SitemapController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use Laravel\Fortify\Features;

// Home - Selector de rubros
Route::get('/', function () {
    return Inertia::render('Home');
})->name('home');

// ARRIENDO DE MAQUINARIA
Route::get('/maquinaria', [MachineController::class, 'index'])->name('machines.index');
Route::get('/maquinaria/{slug}', [MachineController::class, 'show'])->name('machines.show');

// COTIZACIONES
Route::get('/cotizar', [QuotationController::class, 'create'])->name('quotations.create');
Route::post('/cotizar', [QuotationController::class, 'store'])->name('quotations.store');
Route::get('/cotizar/exito/{id}', [QuotationController::class, 'success'])->name('quotations.success');
Route::get('/cotizar/pdf/{id}', [QuotationController::class, 'downloadPdf'])->name('quotations.pdf');

// EMPRESA CONSTRUCTORA
Route::get('/constructora', [BuilderController::class, 'index'])->name('builder.index');
Route::get('/proyectos', [ProjectController::class, 'index'])->name('projects.index');
Route::get('/proyectos/{slug}', [ProjectController::class, 'show'])->name('projects.show');

// PÁGINAS LEGALES
Route::get('/politica-de-privacidad', [LegalController::class, 'privacy'])->name('legal.privacy');
Route::get('/terminos-y-condiciones', [LegalController::class, 'terms'])->name('legal.terms');

// SITEMAP
Route::get('/sitemap.xml', [SitemapController::class, 'index'])->name('sitemap');

// Rutas de autenticación (mantener para admin)
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('dashboard', function () {
        return Inertia::render('dashboard');
    })->name('dashboard');
});

require __DIR__.'/settings.php';
