<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante de Cotización - Akiyan</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        @page {
            margin: 20mm;
        }
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 9px;
            color: #262727;
            line-height: 1.4;
            background: #ffffff;
            margin: 0;
            padding: 0;
        }
        .header {
            background: linear-gradient(135deg, #262727 0%, #30292A 100%);
            color: white;
            padding: 15px 20px;
            margin-bottom: 15px;
            border-radius: 0;
        }
        .header-content {
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        .logo-container {
            display: flex;
            align-items: center;
            gap: 12px;
        }
        .logo {
            height: 55px;
            width: auto;
            max-width: 180px;
            object-fit: contain;
        }
        .header-text {
            flex: 1;
        }
        .header-text h1 {
            font-size: 16px;
            margin-bottom: 3px;
            font-weight: bold;
            letter-spacing: 0.5px;
        }
        .header-text p {
            font-size: 9px;
            opacity: 0.95;
            font-weight: 500;
        }
        .quotation-badge {
            background: #00E700;
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: bold;
            font-size: 11px;
            white-space: nowrap;
            box-shadow: 0 2px 4px rgba(0, 231, 0, 0.3);
        }
        .container {
            max-width: 700px;
            margin: 0 auto;
            padding: 0 15px;
        }
        .info-section {
            background: #ffffff;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 12px;
            border: 1px solid #e5e7eb;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
            page-break-inside: avoid;
        }
        .info-section h2 {
            color: #00E700;
            font-size: 11px;
            margin-bottom: 10px;
            border-bottom: 3px solid #00E700;
            padding-bottom: 6px;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 4px 0;
            border-bottom: 1px solid #f0f0f0;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: 600;
            color: #30292A;
            width: 40%;
            font-size: 9px;
        }
        .info-value {
            color: #262727;
            width: 60%;
            text-align: right;
            font-size: 9px;
        }
        .machines-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
            border: 1px solid #e5e7eb;
            font-size: 8px;
        }
        .machines-table thead {
            display: table-header-group;
        }
        .machines-table tbody {
            display: table-row-group;
        }
        .machines-table th {
            background: linear-gradient(135deg, #00E700 0%, #00C803 100%);
            color: white;
            padding: 8px 10px;
            text-align: left;
            font-weight: bold;
            font-size: 9px;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        .machines-table td {
            padding: 8px 10px;
            border-bottom: 1px solid #f0f0f0;
            font-size: 9px;
        }
        .machines-table tr:last-child td {
            border-bottom: none;
        }
        .machines-table tr:nth-child(even) {
            background: #f9fafb;
        }
        .machines-table tbody tr {
            page-break-inside: avoid;
        }
        .footer {
            margin-top: 15px;
            padding-top: 10px;
            border-top: 2px solid #00E700;
            text-align: center;
            color: #666;
            font-size: 7px;
            background: #f9fafb;
            padding: 10px;
            border-radius: 4px;
            page-break-inside: avoid;
        }
        .footer strong {
            color: #262727;
            font-size: 8px;
        }
        .status-badge {
            display: inline-block;
            padding: 3px 10px;
            border-radius: 12px;
            font-weight: bold;
            font-size: 8px;
            text-transform: uppercase;
            letter-spacing: 0.3px;
        }
        .status-pending {
            background: #fef3c7;
            color: #92400e;
            border: 1px solid #fbbf24;
        }
        .status-approved {
            background: #d1fae5;
            color: #065f46;
            border: 1px solid #10b981;
        }
        .status-rejected {
            background: #fee2e2;
            color: #991b1b;
            border: 1px solid #ef4444;
        }
        .notes-section {
            margin-top: 10px;
            padding: 10px;
            background: #fffbeb;
            border-left: 3px solid #fbbf24;
            border-radius: 4px;
            border: 1px solid #fef3c7;
            page-break-inside: avoid;
        }
        .notes-section h3 {
            font-size: 9px;
            margin-bottom: 5px;
            color: #92400e;
            font-weight: bold;
            text-transform: uppercase;
        }
        .notes-section p {
            color: #78350f;
            font-size: 8px;
            line-height: 1.4;
        }
        .date-info {
            display: inline-block;
            background: #f0fdf4;
            padding: 4px 10px;
            border-radius: 4px;
            border: 1px solid #86efac;
            color: #166534;
            font-weight: 600;
            font-size: 8px;
        }
        .two-columns {
            display: table;
            width: 100%;
            margin-bottom: 12px;
            table-layout: fixed;
        }
        .column {
            display: table-cell;
            width: 50%;
            vertical-align: top;
            padding-right: 8px;
        }
        .column:last-child {
            padding-right: 0;
            padding-left: 8px;
        }
        .logo-wrapper {
            display: inline-block;
            background: white;
            padding: 5px;
            border-radius: 6px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div class="logo-container">
                <div class="logo-wrapper">
                    @if(isset($logoPath) && $logoPath && file_exists($logoPath))
                    <img src="{{ $logoPath }}" alt="Akiyan Logo" class="logo" />
                    @else
                    @php
                        $logoPath1 = public_path('storage/logoAkiyan.png');
                        $logoPath2 = storage_path('app/public/logoAkiyan.png');
                        $logoPath = file_exists($logoPath1) ? $logoPath1 : (file_exists($logoPath2) ? $logoPath2 : null);
                    @endphp
                    @if($logoPath && file_exists($logoPath))
                    <img src="{{ $logoPath }}" alt="Akiyan Logo" class="logo" />
                    @else
                    <div style="height: 55px; width: 180px; background: white; border-radius: 4px; display: flex; align-items: center; justify-content: center; color: #262727; font-weight: bold; font-size: 14px; padding: 10px;">
                        AKIYAN
                    </div>
                    @endif
                    @endif
                </div>
                <div class="header-text">
                    <h1>AKIYAN</h1>
                    <p>Constructora y Arriendo de Maquinaria</p>
                </div>
            </div>
            <div class="quotation-badge">
                SOLICITUD DE COTIZACIÓN #{{ str_pad($quotation->id, 6, '0', STR_PAD_LEFT) }}
            </div>
        </div>
    </div>

    <div class="container">
        <!-- Información en dos columnas -->
        <div class="two-columns">
            <div class="column">
                <!-- Información del Cliente -->
                <div class="info-section">
                    <h2>Información del Cliente</h2>
                    <div class="info-row">
                        <span class="info-label">Nombre:</span>
                        <span class="info-value">{{ $quotation->visitor_name }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Email:</span>
                        <span class="info-value" style="font-size: 8px;">{{ $quotation->visitor_email }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Teléfono:</span>
                        <span class="info-value">{{ $quotation->visitor_phone }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Estado:</span>
                        <span class="info-value">
                            <span class="status-badge @if($quotation->status == 'pending') status-pending @elseif($quotation->status == 'approved') status-approved @elseif($quotation->status == 'rejected') status-rejected @else status-pending @endif">
                                @if($quotation->status == 'pending')
                                    Pendiente
                                @elseif($quotation->status == 'approved')
                                    Aprobada
                                @elseif($quotation->status == 'rejected')
                                    Rechazada
                                @else
                                    Completada
                                @endif
                            </span>
                        </span>
                    </div>
                </div>
            </div>
            <div class="column">
                <!-- Rango de Fechas -->
                <div class="info-section">
                    <h2>Período de Arriendo</h2>
                    <div class="info-row">
                        <span class="info-label">Fecha Inicio:</span>
                        <span class="info-value">{{ \Carbon\Carbon::parse($quotation->start_date)->format('d/m/Y') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Fecha Fin:</span>
                        <span class="info-value">{{ \Carbon\Carbon::parse($quotation->end_date)->format('d/m/Y') }}</span>
                    </div>
                    <div class="info-row">
                        <span class="info-label">Duración:</span>
                        <span class="info-value">
                            <span class="date-info">
                                {{ \Carbon\Carbon::parse($quotation->start_date)->diffInDays(\Carbon\Carbon::parse($quotation->end_date)) }} días
                            </span>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Máquinas -->
        <div class="info-section">
            <h2>Máquinas Solicitadas</h2>
            <table class="machines-table">
                <thead>
                    <tr>
                        <th style="width: 5%;">#</th>
                        <th style="width: 45%;">Máquina</th>
                        <th style="width: 20%;">Categoría</th>
                        <th style="width: 15%;">Cantidad</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($quotation->machines as $index => $machine)
                    <tr>
                        <td style="text-align: center; font-weight: bold;">{{ $index + 1 }}</td>
                        <td style="font-weight: 600;">{{ $machine->name }}</td>
                        <td>{{ $machine->category }}</td>
                        <td style="text-align: center; font-weight: bold;">{{ $machine->pivot->quantity ?? 1 }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        @if($quotation->notes)
        <div class="notes-section">
            <h3>Notas Adicionales</h3>
            <p>{{ $quotation->notes }}</p>
        </div>
        @endif

        <div class="footer">
            <p style="margin: 3px 0;"><strong>AKIYAN - Constructora y Arriendo de Maquinaria</strong></p>
            <p style="margin: 3px 0;">San Carlos, Ñuble, Chile | Fecha: {{ \Carbon\Carbon::now()->format('d/m/Y H:i') }}</p>
            <p style="margin: 3px 0; font-size: 6px; color: #9ca3af;">
                Documento generado automáticamente. Comprobante de solicitud de cotización.
            </p>
        </div>
    </div>
</body>
</html>

