import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition, applyUrlDefaults } from './../../wayfinder'
/**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
export const create = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})

create.definition = {
    methods: ["get","head"],
    url: '/cotizar',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
create.url = (options?: RouteQueryOptions) => {
    return create.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
create.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: create.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
create.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: create.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
    const createForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: create.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
        createForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\QuotationController::create
 * @see app/Http/Controllers/QuotationController.php:15
 * @route '/cotizar'
 */
        createForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: create.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    create.form = createForm
/**
* @see \App\Http\Controllers\QuotationController::store
 * @see app/Http/Controllers/QuotationController.php:41
 * @route '/cotizar'
 */
export const store = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

store.definition = {
    methods: ["post"],
    url: '/cotizar',
} satisfies RouteDefinition<["post"]>

/**
* @see \App\Http\Controllers\QuotationController::store
 * @see app/Http/Controllers/QuotationController.php:41
 * @route '/cotizar'
 */
store.url = (options?: RouteQueryOptions) => {
    return store.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotationController::store
 * @see app/Http/Controllers/QuotationController.php:41
 * @route '/cotizar'
 */
store.post = (options?: RouteQueryOptions): RouteDefinition<'post'> => ({
    url: store.url(options),
    method: 'post',
})

    /**
* @see \App\Http\Controllers\QuotationController::store
 * @see app/Http/Controllers/QuotationController.php:41
 * @route '/cotizar'
 */
    const storeForm = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
        action: store.url(options),
        method: 'post',
    })

            /**
* @see \App\Http\Controllers\QuotationController::store
 * @see app/Http/Controllers/QuotationController.php:41
 * @route '/cotizar'
 */
        storeForm.post = (options?: RouteQueryOptions): RouteFormDefinition<'post'> => ({
            action: store.url(options),
            method: 'post',
        })
    
    store.form = storeForm
/**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
export const success = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: success.url(args, options),
    method: 'get',
})

success.definition = {
    methods: ["get","head"],
    url: '/cotizar/exito/{id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
success.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        id: args.id,
                }

    return success.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
success.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: success.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
success.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: success.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
    const successForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: success.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
        successForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: success.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\QuotationController::success
 * @see app/Http/Controllers/QuotationController.php:79
 * @route '/cotizar/exito/{id}'
 */
        successForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: success.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    success.form = successForm
/**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
export const pdf = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: pdf.url(args, options),
    method: 'get',
})

pdf.definition = {
    methods: ["get","head"],
    url: '/cotizar/pdf/{id}',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
pdf.url = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions) => {
    if (typeof args === 'string' || typeof args === 'number') {
        args = { id: args }
    }

    
    if (Array.isArray(args)) {
        args = {
                    id: args[0],
                }
    }

    args = applyUrlDefaults(args)

    const parsedArgs = {
                        id: args.id,
                }

    return pdf.definition.url
            .replace('{id}', parsedArgs.id.toString())
            .replace(/\/+$/, '') + queryParams(options)
}

/**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
pdf.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: pdf.url(args, options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
pdf.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: pdf.url(args, options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
    const pdfForm = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: pdf.url(args, options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
        pdfForm.get = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: pdf.url(args, options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\QuotationController::pdf
 * @see app/Http/Controllers/QuotationController.php:88
 * @route '/cotizar/pdf/{id}'
 */
        pdfForm.head = (args: { id: string | number } | [id: string | number ] | string | number, options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: pdf.url(args, {
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    pdf.form = pdfForm
const quotations = {
    create: Object.assign(create, create),
store: Object.assign(store, store),
success: Object.assign(success, success),
pdf: Object.assign(pdf, pdf),
}

export default quotations