import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../wayfinder'
/**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
export const privacy = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: privacy.url(options),
    method: 'get',
})

privacy.definition = {
    methods: ["get","head"],
    url: '/politica-de-privacidad',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
privacy.url = (options?: RouteQueryOptions) => {
    return privacy.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
privacy.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: privacy.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
privacy.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: privacy.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
    const privacyForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: privacy.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
        privacyForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: privacy.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\LegalController::privacy
 * @see app/Http/Controllers/LegalController.php:9
 * @route '/politica-de-privacidad'
 */
        privacyForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: privacy.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    privacy.form = privacyForm
/**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
export const terms = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: terms.url(options),
    method: 'get',
})

terms.definition = {
    methods: ["get","head"],
    url: '/terminos-y-condiciones',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
terms.url = (options?: RouteQueryOptions) => {
    return terms.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
terms.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: terms.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
terms.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: terms.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
    const termsForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: terms.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
        termsForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: terms.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\LegalController::terms
 * @see app/Http/Controllers/LegalController.php:14
 * @route '/terminos-y-condiciones'
 */
        termsForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: terms.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    terms.form = termsForm
const legal = {
    privacy: Object.assign(privacy, privacy),
terms: Object.assign(terms, terms),
}

export default legal