import { Head, Link } from '@inertiajs/react';
import { Topbar } from '@/components/Topbar';
import { InfoBar } from '@/components/InfoBar';
import { Footer } from '@/components/Footer';
import { WhatsAppChat } from '@/components/WhatsAppChat';

export default function Terms() {
    return (
        <>
            <Head title="Términos y Condiciones - Akiyan" />
            <InfoBar />
            <Topbar />
            <div className="min-h-screen bg-gray-50">
                {/* Header */}
                <div className="relative overflow-hidden shadow-sm">
                    {/* Background Image */}
                    <div
                        className="absolute inset-0 bg-cover bg-center bg-no-repeat"
                        style={{
                            backgroundImage: 'url(/storage/fondo1.svg)',
                        }}
                    >
                        {/* Overlay for better text readability */}
                        <div className="absolute inset-0 bg-gradient-to-br from-[#262727]/60 to-[#30292A]/60" />
                        
                        {/* Shine Effect */}
                        <div className="absolute inset-0 overflow-hidden">
                            <div 
                                className="absolute inset-0 bg-gradient-to-r from-transparent via-white/30 to-transparent -skew-x-12"
                                style={{
                                    animation: 'shine 4s infinite',
                                }}
                            />
                        </div>
                    </div>
                    <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                        <div className="flex items-center justify-between">
                            <div>
                                <h1 className="text-2xl font-bold text-white mb-1">
                                    Términos y Condiciones
                                </h1>
                                <p className="text-sm text-gray-200">
                                    Condiciones de uso de nuestros servicios
                                </p>
                            </div>
                            <Link
                                href="/"
                                className="text-white hover:text-[#00E700] transition-colors"
                            >
                                ← Volver al inicio
                            </Link>
                        </div>
                    </div>
                </div>

                {/* Content */}
                <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                    <div className="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                1. Información General
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Los presentes Términos y Condiciones regulan el uso del sitio web de 
                                <strong> Constructora y Arriendo de Maquinaria Akiyan</strong> (en adelante, "Akiyan"). 
                                El acceso y uso de este sitio web implica la aceptación de estos términos. 
                                Si no está de acuerdo con alguna de estas condiciones, le rogamos que no utilice nuestro sitio web.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                2. Servicios Ofrecidos
                            </h2>
                            <p className="text-[#30292A] leading-relaxed mb-4">
                                Akiyan ofrece los siguientes servicios a través de su sitio web:
                            </p>
                            <ul className="list-disc list-inside space-y-2 text-[#30292A] ml-4">
                                <li>Información sobre servicios de arriendo de maquinaria pesada.</li>
                                <li>Información sobre servicios de construcción.</li>
                                <li>Catálogo de maquinaria disponible para arriendo.</li>
                                <li>Portafolio de proyectos ejecutados.</li>
                                <li>Formularios de contacto y comunicación vía WhatsApp.</li>
                            </ul>
                            <p className="text-[#30292A] leading-relaxed mt-4">
                                Este sitio web es únicamente informativo y no constituye una plataforma de comercio electrónico. 
                                No se realizan transacciones de compra o reserva automática a través del sitio.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                3. Uso del Sitio Web
                            </h2>
                            <p className="text-[#30292A] leading-relaxed mb-4">
                                El usuario se compromete a utilizar el sitio web de forma adecuada y conforme a la ley. 
                                Queda expresamente prohibido:
                            </p>
                            <ul className="list-disc list-inside space-y-2 text-[#30292A] ml-4">
                                <li>Utilizar el sitio web para fines ilegales o no autorizados.</li>
                                <li>Reproducir, copiar o distribuir el contenido sin autorización.</li>
                                <li>Intentar acceder a áreas restringidas del sitio web.</li>
                                <li>Realizar acciones que puedan dañar, deshabilitar o sobrecargar el sitio web.</li>
                                <li>Utilizar robots, spiders o cualquier dispositivo automatizado para acceder al sitio.</li>
                            </ul>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                4. Propiedad Intelectual
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Todo el contenido del sitio web, incluyendo textos, imágenes, logotipos, diseños, 
                                y cualquier otro material, es propiedad de Akiyan o de sus respectivos propietarios y 
                                está protegido por las leyes de propiedad intelectual e industrial. El uso no autorizado 
                                de este contenido está prohibido.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                5. Información y Cotizaciones
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                La información proporcionada en este sitio web tiene carácter meramente informativo. 
                                Las cotizaciones y precios, cuando se proporcionen, son estimaciones y pueden variar según 
                                las condiciones específicas de cada proyecto. Toda cotización formal debe ser confirmada 
                                mediante contacto directo con Akiyan.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                6. Enlaces a Terceros
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                El sitio web puede contener enlaces a sitios web de terceros. Akiyan no se hace responsable 
                                del contenido, políticas de privacidad o prácticas de estos sitios externos. El acceso a 
                                estos enlaces es bajo la responsabilidad del usuario.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                7. Limitación de Responsabilidad
                            </h2>
                            <p className="text-[#30292A] leading-relaxed mb-4">
                                Akiyan no se hace responsable de:
                            </p>
                            <ul className="list-disc list-inside space-y-2 text-[#30292A] ml-4">
                                <li>Daños derivados del uso o imposibilidad de uso del sitio web.</li>
                                <li>Interrupciones, errores o fallos técnicos en el sitio web.</li>
                                <li>Decisiones tomadas basándose únicamente en la información del sitio web.</li>
                                <li>Contenido generado por usuarios o terceros.</li>
                            </ul>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                8. Modificaciones del Sitio Web
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Akiyan se reserva el derecho de modificar, suspender o interrumpir, total o parcialmente, 
                                el sitio web en cualquier momento sin previo aviso. Asimismo, puede modificar estos Términos 
                                y Condiciones en cualquier momento, siendo responsabilidad del usuario revisar periódicamente 
                                estos términos.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                9. Ley Aplicable y Jurisdicción
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Estos Términos y Condiciones se rigen por la legislación chilena. Para cualquier controversia 
                                derivada del uso del sitio web, las partes se someten a los tribunales ordinarios de Chile, 
                                renunciando expresamente a cualquier otro fuero que pudiera corresponderles.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                10. Contacto
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Para cualquier consulta relacionada con estos Términos y Condiciones, puede contactarnos 
                                a través de los medios proporcionados en nuestro sitio web, incluyendo WhatsApp, correo 
                                electrónico o teléfono.
                            </p>
                        </section>

                        <div className="pt-8 border-t border-gray-200">
                            <p className="text-sm text-[#30292A]">
                                <strong>Última actualización:</strong> {new Date().toLocaleDateString('es-CL', { year: 'numeric', month: 'long', day: 'numeric' })}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <Footer />
            <WhatsAppChat />
            <style>{`
                @keyframes shine {
                    0% {
                        transform: translateX(-100%) skewX(-12deg);
                    }
                    50% {
                        transform: translateX(200%) skewX(-12deg);
                    }
                    100% {
                        transform: translateX(200%) skewX(-12deg);
                    }
                }
            `}</style>
        </>
    );
}

