import { Head, Link } from '@inertiajs/react';
import { Topbar } from '@/components/Topbar';
import { InfoBar } from '@/components/InfoBar';
import { Footer } from '@/components/Footer';
import { WhatsAppChat } from '@/components/WhatsAppChat';

export default function Privacy() {
    return (
        <>
            <Head title="Política de Privacidad - Akiyan" />
            <InfoBar />
            <Topbar />
            <div className="min-h-screen bg-gray-50">
                {/* Header */}
                <div className="relative overflow-hidden shadow-sm">
                    {/* Background Image */}
                    <div
                        className="absolute inset-0 bg-cover bg-center bg-no-repeat"
                        style={{
                            backgroundImage: 'url(/storage/fondo1.svg)',
                        }}
                    >
                        {/* Overlay for better text readability */}
                        <div className="absolute inset-0 bg-gradient-to-br from-[#262727]/60 to-[#30292A]/60" />
                        
                        {/* Shine Effect */}
                        <div className="absolute inset-0 overflow-hidden">
                            <div 
                                className="absolute inset-0 bg-gradient-to-r from-transparent via-white/30 to-transparent -skew-x-12"
                                style={{
                                    animation: 'shine 4s infinite',
                                }}
                            />
                        </div>
                    </div>
                    <div className="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
                        <div className="flex items-center justify-between">
                            <div>
                                <h1 className="text-2xl font-bold text-white mb-1">
                                    Política de Privacidad
                                </h1>
                                <p className="text-sm text-gray-200">
                                    Protección y tratamiento de datos personales
                                </p>
                            </div>
                            <Link
                                href="/"
                                className="text-white hover:text-[#00E700] transition-colors"
                            >
                                ← Volver al inicio
                            </Link>
                        </div>
                    </div>
                </div>

                {/* Content */}
                <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                    <div className="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                1. Identificación del Responsable del Tratamiento
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                <strong>Constructora y Arriendo de Maquinaria Akiyan</strong>, con domicilio en Chile, 
                                es responsable del tratamiento de los datos personales recopilados a través de este sitio web.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                2. Finalidades del Tratamiento de los Datos Personales
                            </h2>
                            <p className="text-[#30292A] leading-relaxed mb-4">
                                Los datos personales proporcionados por los usuarios serán utilizados con las siguientes finalidades:
                            </p>
                            <ul className="list-disc list-inside space-y-2 text-[#30292A] ml-4">
                                <li>Gestionar las solicitudes de información, alquiler o cotización de maquinaria.</li>
                                <li>Procesar consultas relacionadas con servicios de construcción y arriendo de maquinaria.</li>
                                <li>Enviar comunicaciones comerciales relacionadas con nuestros productos y servicios, siempre que el usuario haya dado su consentimiento.</li>
                                <li>Mejorar la experiencia del usuario en nuestro sitio web mediante el análisis de hábitos de navegación.</li>
                                <li>Gestionar el contacto a través de WhatsApp y otros canales de comunicación.</li>
                            </ul>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                3. Legitimación para el Tratamiento de los Datos
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                El tratamiento de los datos personales se basa en el consentimiento otorgado por el usuario 
                                al completar los formularios de contacto, al suscribirse a nuestras comunicaciones o al 
                                contactarnos a través de WhatsApp u otros medios proporcionados en el sitio web.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                4. Conservación de los Datos
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Los datos personales se conservarán durante el tiempo necesario para cumplir con las finalidades 
                                para las cuales fueron recopilados y para determinar las posibles responsabilidades que se pudieran 
                                derivar de dichas finalidades y del tratamiento de los datos. Una vez cumplidos estos plazos, 
                                los datos serán eliminados de forma segura.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                5. Comunicación de los Datos
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                No se cederán datos a terceros, salvo obligación legal o en el caso de que sea necesario para 
                                la prestación del servicio solicitado por el usuario. En ningún caso se realizarán transferencias 
                                internacionales de datos sin el consentimiento explícito del usuario.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                6. Derechos de los Usuarios
                            </h2>
                            <p className="text-[#30292A] leading-relaxed mb-4">
                                Los usuarios tienen derecho a:
                            </p>
                            <ul className="list-disc list-inside space-y-2 text-[#30292A] ml-4">
                                <li>Acceder a sus datos personales.</li>
                                <li>Solicitar la rectificación de datos inexactos.</li>
                                <li>Solicitar la supresión de sus datos cuando, entre otros motivos, los datos ya no sean necesarios para los fines que fueron recogidos.</li>
                                <li>Oponerse al tratamiento de sus datos.</li>
                                <li>Solicitar la limitación del tratamiento de sus datos en determinadas circunstancias.</li>
                                <li>Solicitar la portabilidad de sus datos.</li>
                            </ul>
                            <p className="text-[#30292A] leading-relaxed mt-4">
                                Para ejercer estos derechos, los usuarios pueden enviar una solicitud por escrito a nuestro 
                                correo electrónico de contacto o a través de los canales de comunicación proporcionados en el sitio web.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                7. Medidas de Seguridad
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                <strong>Constructora y Arriendo de Maquinaria Akiyan</strong> ha adoptado las medidas técnicas 
                                y organizativas necesarias para garantizar la seguridad de los datos personales y evitar su alteración, 
                                pérdida, tratamiento o acceso no autorizado, de acuerdo con la normativa vigente en materia de 
                                protección de datos personales en Chile.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                8. Cookies y Tecnologías Similares
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Este sitio web puede utilizar cookies y tecnologías similares para mejorar la experiencia del usuario. 
                                El usuario puede configurar su navegador para rechazar cookies, aunque esto puede afectar algunas 
                                funcionalidades del sitio.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                9. Modificaciones de la Política de Privacidad
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                <strong>Constructora y Arriendo de Maquinaria Akiyan</strong> se reserva el derecho de modificar 
                                esta Política de Privacidad para adaptarla a novedades legislativas o jurisprudenciales. En tales 
                                casos, se anunciarán en este sitio web los cambios introducidos con razonable antelación a su puesta 
                                en práctica. Se recomienda revisar periódicamente esta política.
                            </p>
                        </section>

                        <section>
                            <h2 className="text-2xl font-bold text-[#262727] mb-4">
                                10. Contacto
                            </h2>
                            <p className="text-[#30292A] leading-relaxed">
                                Para cualquier consulta relacionada con esta Política de Privacidad o el tratamiento de sus datos 
                                personales, puede contactarnos a través de los medios proporcionados en nuestro sitio web, incluyendo 
                                WhatsApp, correo electrónico o teléfono.
                            </p>
                        </section>

                        <div className="pt-8 border-t border-gray-200">
                            <p className="text-sm text-[#30292A]">
                                <strong>Última actualización:</strong> {new Date().toLocaleDateString('es-CL', { year: 'numeric', month: 'long', day: 'numeric' })}
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <Footer />
            <WhatsAppChat />
            <style>{`
                @keyframes shine {
                    0% {
                        transform: translateX(-100%) skewX(-12deg);
                    }
                    50% {
                        transform: translateX(200%) skewX(-12deg);
                    }
                    100% {
                        transform: translateX(200%) skewX(-12deg);
                    }
                }
            `}</style>
        </>
    );
}

