import { Head, Link } from '@inertiajs/react';
import { SEO } from '@/components/SEO';
import { useState, useEffect } from 'react';
import { Topbar } from '@/components/Topbar';
import { InfoBar } from '@/components/InfoBar';
import { Footer } from '@/components/Footer';
import { WhatsAppChat } from '@/components/WhatsAppChat';

export default function Home() {
    const slides = [
        {
            title: 'Constructora y Arriendo de Maquinaria',
            subtitle: 'Akiyan',
            description: 'Soluciones integrales en construcción y maquinaria pesada para proyectos de excelencia',
            features: [
                { icon: '✓', text: 'Más de 15 años de experiencia' },
                { icon: '✓', text: 'Maquinaria de última generación' },
                { icon: '✓', text: 'Servicio profesional garantizado' },
            ],
            stats: [
                { number: '15+', label: 'Años de Experiencia' },
                { number: '200+', label: 'Proyectos Completados' },
                { number: '42+', label: 'Máquinas Disponibles' },
            ],
        },
    ];

    const [currentSlide, setCurrentSlide] = useState(0);
    const [isVisible, setIsVisible] = useState(false);

    useEffect(() => {
        setIsVisible(true);
    }, []);

    const goToSlide = (index: number) => {
        setCurrentSlide(index);
    };

    const goToPrevious = () => {
        setCurrentSlide((prev) => (prev - 1 + slides.length) % slides.length);
    };

    const goToNext = () => {
        setCurrentSlide((prev) => (prev + 1) % slides.length);
    };

    return (
        <>
            <SEO
                title="Akiyan - Arriendo de Maquinaria Pesada en San Carlos, Ñuble, Chile"
                description="Akiyan: Constructora y arriendo de maquinaria pesada en San Carlos, Ñuble, Chile. Más de 15 años de experiencia. Más de 42 máquinas disponibles para arriendo. Servicio profesional en toda la región de Ñuble."
                keywords="arriendo maquinaria ñuble, arriendo maquinaria san carlos, constructora ñuble, maquinaria pesada san carlos, arriendo excavadoras ñuble, construcción san carlos ñuble, arriendo maquinaria construcción chile"
                canonical={typeof window !== 'undefined' ? window.location.origin : ''}
            />
            <Head title="Akiyan - Constructora y Arriendo de Maquinaria" />
            <InfoBar />
            <Topbar />
            <div className="min-h-screen bg-gradient-to-br from-gray-50 via-white to-gray-50">
                {/* Hero Slider Section */}
                <div className="relative overflow-hidden">
                    {/* Background Image */}
                    <div
                        className="absolute inset-0 bg-cover bg-center bg-no-repeat"
                        style={{
                            backgroundImage: 'url(/storage/fondo1.svg)',
                        }}
                    >
                        {/* Overlay for better text readability */}
                        <div className="absolute inset-0 bg-gradient-to-br from-[#262727]/50 to-[#30292A]/50" />
                        
                        {/* Shine Effect */}
                        <div className="absolute inset-0 overflow-hidden">
                            <div 
                                className="absolute inset-0 bg-gradient-to-r from-transparent via-white/30 to-transparent -skew-x-12 animate-shine" 
                            />
                        </div>
                    </div>
                    <div className="relative w-full px-4 sm:px-6 lg:px-8 py-12 md:py-20 lg:py-24">
                        <div className={`relative min-h-[500px] md:min-h-[600px] lg:min-h-[700px] max-w-[95%] mx-auto ${isVisible ? 'animate-fade-in-up' : 'opacity-0'}`}>
                            {slides.map((slide, index) => (
                                <div
                                    key={index}
                                    className={`absolute inset-0 flex flex-col items-center justify-center text-center transition-all duration-1000 ease-in-out ${
                                        index === currentSlide
                                            ? 'opacity-100 translate-x-0'
                                            : index < currentSlide
                                              ? 'opacity-0 -translate-x-full'
                                              : 'opacity-0 translate-x-full'
                                    }`}
                                >
                                    {/* Badge de confianza */}
                                    <div className="mb-4 animate-fade-in-up" style={{ animationDelay: '0.1s' }}>
                                        <span className="inline-flex items-center gap-2 bg-white/10 backdrop-blur-sm text-white px-4 py-2 rounded-full text-sm font-semibold border border-white/20">
                                            <svg className="w-4 h-4 text-[#00E700]" fill="currentColor" viewBox="0 0 20 20">
                                                <path fillRule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                                            </svg>
                                            Empresa Certificada
                                        </span>
                                    </div>

                                    <h1 className="text-2xl md:text-4xl lg:text-5xl font-bold text-white mb-4 px-4 drop-shadow-2xl animate-fade-in-up" style={{ animationDelay: '0.2s' }}>
                                        {slide.title}
                                    </h1>
                                    <h2 className="text-2xl md:text-4xl lg:text-5xl font-semibold text-[#00E700] mb-6 px-4 drop-shadow-lg animate-fade-in-up" style={{ animationDelay: '0.3s' }}>
                                        {slide.subtitle}
                                    </h2>
                                    <p className="text-base md:text-lg lg:text-xl text-gray-200 max-w-3xl mx-auto px-4 drop-shadow-lg mb-8 animate-fade-in-up" style={{ animationDelay: '0.4s' }}>
                                        {slide.description}
                                    </p>

                                    {/* Features List */}
                                    {slide.features && (
                                        <div className="flex flex-wrap justify-center gap-4 mb-8 px-4 animate-fade-in-up" style={{ animationDelay: '0.5s' }}>
                                            {slide.features.map((feature, idx) => (
                                                <div key={idx} className="flex items-center gap-2 bg-white/10 backdrop-blur-sm px-4 py-2 rounded-lg border border-white/20">
                                                    <span className="text-[#00E700] font-bold text-lg">{feature.icon}</span>
                                                    <span className="text-white text-sm md:text-base font-medium">{feature.text}</span>
                                                </div>
                                            ))}
                                        </div>
                                    )}

                                    {/* Statistics */}
                                    {slide.stats && (
                                        <div className="grid grid-cols-3 gap-4 md:gap-8 mb-8 px-4 max-w-4xl mx-auto animate-fade-in-up" style={{ animationDelay: '0.6s' }}>
                                            {slide.stats.map((stat, idx) => (
                                                <div key={idx} className="bg-white/10 backdrop-blur-sm rounded-xl p-4 md:p-6 border border-white/20">
                                                    <div className="text-3xl md:text-4xl font-bold text-[#00E700] mb-1">
                                                        {stat.number}
                                                    </div>
                                                    <div className="text-xs md:text-sm text-gray-200 font-medium">
                                                        {stat.label}
                                                    </div>
                                                </div>
                                            ))}
                                        </div>
                                    )}

                                    {/* CTA Buttons */}
                                    <div className="flex flex-col sm:flex-row gap-4 px-4 animate-fade-in-up" style={{ animationDelay: '0.7s' }}>
                                        <Link
                                            href="/maquinaria"
                                            className="inline-flex items-center justify-center gap-2 bg-[#00E700] hover:bg-[#00D600] text-white font-bold px-6 py-3 md:px-8 md:py-4 rounded-lg transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl"
                                        >
                                            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
                                            </svg>
                                            Ver Catálogo
                                        </Link>
                                        <Link
                                            href="/cotizar"
                                            className="inline-flex items-center justify-center gap-2 bg-white/10 hover:bg-white/20 backdrop-blur-sm text-white font-bold px-6 py-3 md:px-8 md:py-4 rounded-lg transition-all duration-300 transform hover:scale-105 border border-white/30 hover:border-white/50"
                                        >
                                            <svg className="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                            Solicitar Cotización
                                        </Link>
                                    </div>
                                </div>
                            ))}

                            {/* Navigation Arrows - Hidden when only one slide */}
                            {slides.length > 1 && (
                                <>
                                    <button
                                        onClick={goToPrevious}
                                        className="absolute -left-12 md:-left-16 top-1/2 -translate-y-1/2 bg-white/10 hover:bg-white/20 text-white p-3 rounded-full transition-all duration-300 backdrop-blur-sm z-10 hover:scale-110"
                                        aria-label="Slide anterior"
                                    >
                                        <svg
                                            className="w-6 h-6"
                                            fill="none"
                                            stroke="currentColor"
                                            viewBox="0 0 24 24"
                                        >
                                            <path
                                                strokeLinecap="round"
                                                strokeLinejoin="round"
                                                strokeWidth={2}
                                                d="M15 19l-7-7 7-7"
                                            />
                                        </svg>
                                    </button>
                                    <button
                                        onClick={goToNext}
                                        className="absolute -right-12 md:-right-16 top-1/2 -translate-y-1/2 bg-white/10 hover:bg-white/20 text-white p-3 rounded-full transition-all duration-300 backdrop-blur-sm z-10 hover:scale-110"
                                        aria-label="Slide siguiente"
                                    >
                                        <svg
                                            className="w-6 h-6"
                                            fill="none"
                                            stroke="currentColor"
                                            viewBox="0 0 24 24"
                                        >
                                            <path
                                                strokeLinecap="round"
                                                strokeLinejoin="round"
                                                strokeWidth={2}
                                                d="M9 5l7 7-7 7"
                                            />
                                        </svg>
                                    </button>
                                </>
                            )}

                            {/* Dots Indicator - Hidden when only one slide */}
                            {slides.length > 1 && (
                                <div className="absolute bottom-8 left-1/2 -translate-x-1/2 flex space-x-3">
                                    {slides.map((_, index) => (
                                        <button
                                            key={index}
                                            onClick={() => goToSlide(index)}
                                            className={`h-3 rounded-full transition-all duration-300 ${
                                                index === currentSlide
                                                    ? 'w-8 bg-[#00E700]'
                                                    : 'w-3 bg-white/40 hover:bg-white/60'
                                            }`}
                                            aria-label={`Ir al slide ${index + 1}`}
                                        />
                                    ))}
                                </div>
                            )}
                        </div>
                    </div>
                </div>

                {/* Navigation Cards */}
                <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pt-16 md:pt-24 pb-24">
                    <div className={`grid md:grid-cols-2 gap-8 max-w-5xl mx-auto ${isVisible ? 'animate-fade-in-up' : 'opacity-0'}`} style={{ animationDelay: '0.8s' }}>
                        {/* Arriendo de Maquinaria Card */}
                        <Link
                            href="/maquinaria"
                            className="group relative overflow-hidden rounded-2xl bg-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-3 hover:scale-[1.02]"
                        >
                            {/* Gradient overlay on hover */}
                            <div className="absolute inset-0 bg-gradient-to-br from-[#00C803]/0 to-[#00E700]/0 group-hover:from-[#00C803]/5 group-hover:to-[#00E700]/5 transition-all duration-500 z-0" />
                            
                            <div className="aspect-[4/3] relative overflow-hidden">
                                {/* Background Image */}
                                <div 
                                    className="absolute inset-0 bg-cover bg-center bg-no-repeat"
                                    style={{
                                        backgroundImage: 'url(/storage/fondoArriendo.svg)',
                                    }}
                                >
                                    <div className="absolute inset-0 bg-gradient-to-br from-[#00C803]/30 to-[#00E700]/30" />
                                </div>
                                <div className="absolute inset-0 bg-black/5 group-hover:bg-black/2 transition-all duration-500 z-10" />
                                
                                {/* Shimmer effect */}
                                <div className="absolute inset-0 -translate-x-full group-hover:translate-x-full transition-transform duration-1000 bg-gradient-to-r from-transparent via-white/20 to-transparent z-10" />
                            </div>
                            <div className="relative p-8 z-10">
                                <h3 className="text-3xl font-bold text-[#262727] mb-4 group-hover:text-[#00E700] transition-colors duration-300">
                                    Arriendo de Maquinaria
                                </h3>
                                <p className="text-[#30292A] text-lg mb-6 leading-relaxed">
                                    Catálogo completo de maquinaria pesada disponible para arriendo
                                </p>
                                <div className="flex items-center text-[#00E700] font-semibold group-hover:gap-3 transition-all duration-300">
                                    <span>Ver catálogo</span>
                                    <svg
                                        className="w-5 h-5 ml-2 group-hover:translate-x-2 transition-transform duration-300"
                                        fill="none"
                                        stroke="currentColor"
                                        viewBox="0 0 24 24"
                                    >
                                        <path
                                            strokeLinecap="round"
                                            strokeLinejoin="round"
                                            strokeWidth={2}
                                            d="M9 5l7 7-7 7"
                                        />
                                    </svg>
                                </div>
                            </div>
                        </Link>

                        {/* Empresa Constructora Card */}
                        <Link
                            href="/constructora"
                            className="group relative overflow-hidden rounded-2xl bg-white shadow-xl hover:shadow-2xl transition-all duration-500 transform hover:-translate-y-3 hover:scale-[1.02]"
                        >
                            {/* Gradient overlay on hover */}
                            <div className="absolute inset-0 bg-gradient-to-br from-[#262727]/0 to-[#30292A]/0 group-hover:from-[#262727]/5 group-hover:to-[#30292A]/5 transition-all duration-500 z-0" />
                            
                            <div className="aspect-[4/3] relative overflow-hidden">
                                {/* Background Image */}
                                <div 
                                    className="absolute inset-0 bg-cover bg-center bg-no-repeat"
                                    style={{
                                        backgroundImage: 'url(/storage/fondoConstruccion.svg)',
                                    }}
                                >
                                    <div className="absolute inset-0 bg-gradient-to-br from-[#262727]/30 to-[#30292A]/30" />
                                </div>
                                <div className="absolute inset-0 bg-black/5 group-hover:bg-black/2 transition-all duration-500 z-10" />
                                
                                {/* Shimmer effect */}
                                <div className="absolute inset-0 -translate-x-full group-hover:translate-x-full transition-transform duration-1000 bg-gradient-to-r from-transparent via-white/20 to-transparent z-10" />
                            </div>
                            <div className="relative p-8 z-10">
                                <h3 className="text-3xl font-bold text-[#262727] mb-4 group-hover:text-[#00E700] transition-colors duration-300">
                                    Empresa Constructora
                                </h3>
                                <p className="text-[#30292A] text-lg mb-6 leading-relaxed">
                                    Conoce nuestro portafolio de obras y experiencia en construcción
                                </p>
                                <div className="flex items-center text-[#00E700] font-semibold group-hover:gap-3 transition-all duration-300">
                                    <span>Ver portafolio</span>
                                    <svg
                                        className="w-5 h-5 ml-2 group-hover:translate-x-2 transition-transform duration-300"
                                        fill="none"
                                        stroke="currentColor"
                                        viewBox="0 0 24 24"
                                    >
                                        <path
                                            strokeLinecap="round"
                                            strokeLinejoin="round"
                                            strokeWidth={2}
                                            d="M9 5l7 7-7 7"
                                        />
                                    </svg>
                                </div>
                            </div>
                        </Link>
                    </div>
                </div>
            </div>
            <Footer />
            <WhatsAppChat />
        </>
    );
}
