import { queryParams, type RouteQueryOptions, type RouteDefinition, type RouteFormDefinition } from './../../../../wayfinder'
/**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
export const index = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})

index.definition = {
    methods: ["get","head"],
    url: '/constructora',
} satisfies RouteDefinition<["get","head"]>

/**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
index.url = (options?: RouteQueryOptions) => {
    return index.definition.url + queryParams(options)
}

/**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
index.get = (options?: RouteQueryOptions): RouteDefinition<'get'> => ({
    url: index.url(options),
    method: 'get',
})
/**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
index.head = (options?: RouteQueryOptions): RouteDefinition<'head'> => ({
    url: index.url(options),
    method: 'head',
})

    /**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
    const indexForm = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
        action: index.url(options),
        method: 'get',
    })

            /**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
        indexForm.get = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url(options),
            method: 'get',
        })
            /**
* @see \App\Http\Controllers\BuilderController::index
 * @see app/Http/Controllers/BuilderController.php:10
 * @route '/constructora'
 */
        indexForm.head = (options?: RouteQueryOptions): RouteFormDefinition<'get'> => ({
            action: index.url({
                        [options?.mergeQuery ? 'mergeQuery' : 'query']: {
                            _method: 'HEAD',
                            ...(options?.query ?? options?.mergeQuery ?? {}),
                        }
                    }),
            method: 'get',
        })
    
    index.form = indexForm
const BuilderController = { index }

export default BuilderController