<?php

namespace Database\Seeders;

use App\Models\Machine;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class MachineSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $machines = [
            // EQUIPOS ESPECIALES
            [
                'name' => 'Baño Portátil Doble (Conexión a UDO Fosa)',
                'category' => 'Equipos Especiales',
                'brand' => 'Varios',
                'description' => 'Baño portátil doble con conexión a unidad de desagüe y fosa séptica. Mayor capacidad para obras y eventos.',
                'specs_json' => [
                    'Tipo' => 'Portátil',
                    'Conexión' => 'UDO Fosa',
                    'Capacidad' => '2 personas',
                ],
                'applications_json' => [
                    'Obras de construcción',
                    'Eventos temporales',
                    'Campamentos',
                    'Instalaciones temporales',
                ],
            ],
            [
                'name' => 'Escalera Telescópica 9 MT',
                'category' => 'Equipos Especiales',
                'brand' => 'Varios',
                'description' => 'Escalera telescópica extensible hasta 9 metros de altura. Plegable y fácil de transportar.',
                'specs_json' => [
                    'Altura máxima' => '9 metros',
                    'Tipo' => 'Telescópica',
                    'Material' => 'Aluminio',
                ],
                'applications_json' => [
                    'Trabajos en altura',
                    'Mantenimiento de fachadas',
                    'Instalaciones eléctricas',
                    'Pintura y acabados',
                ],
            ],
            [
                'name' => 'Escalera Multipropósito Aluminio 12 Peldaños',
                'category' => 'Equipos Especiales',
                'brand' => 'Varios',
                'description' => 'Escalera de aluminio multipropósito con 12 peldaños. Ligera, resistente y versátil para múltiples aplicaciones.',
                'specs_json' => [
                    'Peldaños' => '12',
                    'Material' => 'Aluminio',
                    'Tipo' => 'Multipropósito',
                ],
                'applications_json' => [
                    'Trabajos en altura',
                    'Mantenimiento',
                    'Instalaciones',
                    'Trabajos generales',
                ],
            ],

            // EQUIPOS PARA CONCRETO
            [
                'name' => 'Betonera Volteo Directo 150 LTS (Bencinera 5 HP / Eléctrica 220V)',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Betonera de volteo directo con capacidad de 150 litros. Disponible en versión bencinera de 5 HP o eléctrica 220V.',
                'specs_json' => [
                    'Capacidad' => '150 litros',
                    'Motor' => 'Bencinera 5 HP / Eléctrica 220V',
                    'Tipo' => 'Volteo directo',
                ],
                'applications_json' => [
                    'Mezcla de concreto',
                    'Preparación de morteros',
                    'Mezcla de materiales',
                    'Obras de construcción',
                ],
            ],
            [
                'name' => 'Betonera Volteo Directo 120 LTS Eléctrica 220V',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Betonera eléctrica de volteo directo con capacidad de 120 litros. Alimentación 220V.',
                'specs_json' => [
                    'Capacidad' => '120 litros',
                    'Motor' => 'Eléctrico 220V',
                    'Tipo' => 'Volteo directo',
                ],
                'applications_json' => [
                    'Mezcla de concreto',
                    'Preparación de morteros',
                    'Mezcla de materiales',
                    'Obras pequeñas y medianas',
                ],
            ],
            [
                'name' => 'Betonera Volteo Directo 400 LTS Eléctrica 220V',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Betonera eléctrica de gran capacidad con volteo directo de 400 litros. Alimentación 220V para obras de mayor envergadura.',
                'specs_json' => [
                    'Capacidad' => '400 litros',
                    'Motor' => 'Eléctrico 220V',
                    'Tipo' => 'Volteo directo',
                ],
                'applications_json' => [
                    'Mezcla de concreto en grandes volúmenes',
                    'Obras de construcción grandes',
                    'Preparación de morteros',
                    'Proyectos industriales',
                ],
            ],
            [
                'name' => 'Vibrador de Hormigón con Sonda 40/50/60 MM',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Vibrador eléctrico para hormigón con sondas intercambiables de 40, 50 y 60 mm de diámetro. Elimina burbujas de aire en el concreto.',
                'specs_json' => [
                    'Tipo' => 'Eléctrico',
                    'Sondas' => '40/50/60 mm',
                    'Aplicación' => 'Vibrado de hormigón',
                ],
                'applications_json' => [
                    'Vibrado de hormigón fresco',
                    'Eliminación de burbujas de aire',
                    'Compactación de concreto',
                    'Mejora de calidad del hormigón',
                ],
            ],
            [
                'name' => 'Regla Vibratoria Radieres',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Regla vibratoria especializada para el alisado y compactación de radieres y losas de hormigón.',
                'specs_json' => [
                    'Tipo' => 'Vibratoria',
                    'Aplicación' => 'Radieres y losas',
                    'Función' => 'Alisado y compactación',
                ],
                'applications_json' => [
                    'Alisado de radieres',
                    'Compactación de losas',
                    'Nivelación de superficies',
                    'Acabado de hormigón',
                ],
            ],
            [
                'name' => 'Alisador de Pavimento',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Equipo para alisado de pavimentos de hormigón. Disponible con plato o sin plato según requerimientos del proyecto.',
                'specs_json' => [
                    'Tipo' => 'Alisador',
                    'Aplicación' => 'Pavimentos',
                    'Opciones' => 'Con plato / Sin plato',
                ],
                'applications_json' => [
                    'Alisado de pavimentos',
                    'Acabado de superficies de hormigón',
                    'Nivelación de pavimentos',
                    'Trabajos de pavimentación',
                ],
            ],
            [
                'name' => 'Platacho de Magnesio con Tres Tubos',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Platacho de magnesio con tres tubos para alisado manual de hormigón y morteros. Herramienta esencial para acabados.',
                'specs_json' => [
                    'Material' => 'Magnesio',
                    'Tubos' => '3',
                    'Tipo' => 'Manual',
                ],
                'applications_json' => [
                    'Alisado de hormigón',
                    'Acabados de morteros',
                    'Nivelación manual',
                    'Trabajos de albañilería',
                ],
            ],
            [
                'name' => 'Llana Fresno de Remate con Tres Tubos',
                'category' => 'Equipos para Concreto',
                'brand' => 'Varios',
                'description' => 'Llana fresno de remate con tres tubos para acabados finales en hormigón y morteros. Proporciona superficie lisa y uniforme.',
                'specs_json' => [
                    'Material' => 'Fresno',
                    'Tubos' => '3',
                    'Tipo' => 'Remate',
                ],
                'applications_json' => [
                    'Acabados finales de hormigón',
                    'Remate de morteros',
                    'Superficies lisas',
                    'Trabajos de acabado',
                ],
            ],

            // COMPACTACIÓN
            [
                'name' => 'Vibropisón Bencinero 5 HP',
                'category' => 'Compactación',
                'brand' => 'Varios',
                'description' => 'Vibropisón bencinero de 5 HP para compactación de suelos y terrenos. Ideal para zanjas y áreas reducidas.',
                'specs_json' => [
                    'Potencia' => '5 HP',
                    'Combustible' => 'Bencina',
                    'Tipo' => 'Vibropisón',
                ],
                'applications_json' => [
                    'Compactación de suelos',
                    'Compactación de zanjas',
                    'Preparación de terrenos',
                    'Trabajos de relleno',
                ],
            ],
            [
                'name' => 'Placa Compactadora Diésel 10 HP',
                'category' => 'Compactación',
                'brand' => 'Varios',
                'description' => 'Placa compactadora diésel de 10 HP para compactación de suelos y materiales granulares en áreas medianas.',
                'specs_json' => [
                    'Potencia' => '10 HP',
                    'Combustible' => 'Diésel',
                    'Tipo' => 'Placa compactadora',
                ],
                'applications_json' => [
                    'Compactación de suelos',
                    'Compactación de asfalto',
                    'Preparación de terrenos',
                    'Trabajos de pavimentación',
                ],
            ],
            [
                'name' => 'Placa Compactadora Bencinera 6.5 HP',
                'category' => 'Compactación',
                'brand' => 'Varios',
                'description' => 'Placa compactadora bencinera de 6.5 HP para compactación de suelos y materiales en obras medianas.',
                'specs_json' => [
                    'Potencia' => '6.5 HP',
                    'Combustible' => 'Bencina',
                    'Tipo' => 'Placa compactadora',
                ],
                'applications_json' => [
                    'Compactación de suelos',
                    'Compactación de asfalto',
                    'Preparación de terrenos',
                    'Trabajos de construcción',
                ],
            ],
            [
                'name' => 'Placa Compactadora Bencinera 5 HP',
                'category' => 'Compactación',
                'brand' => 'Varios',
                'description' => 'Placa compactadora bencinera de 5 HP para compactación de suelos en obras pequeñas y medianas.',
                'specs_json' => [
                    'Potencia' => '5 HP',
                    'Combustible' => 'Bencina',
                    'Tipo' => 'Placa compactadora',
                ],
                'applications_json' => [
                    'Compactación de suelos',
                    'Compactación de asfalto',
                    'Preparación de terrenos',
                    'Trabajos de construcción',
                ],
            ],

            // TOPOGRAFÍA
            [
                'name' => 'Nivel Topográfico con Trípode y Mira',
                'category' => 'Topografía',
                'brand' => 'Varios',
                'description' => 'Nivel topográfico completo con trípode y mira para mediciones de nivelación y altimetría en obras y terrenos.',
                'specs_json' => [
                    'Tipo' => 'Nivel topográfico',
                    'Incluye' => 'Trípode y mira',
                    'Aplicación' => 'Topografía',
                ],
                'applications_json' => [
                    'Nivelación de terrenos',
                    'Mediciones topográficas',
                    'Replanteo de obras',
                    'Control de alturas',
                ],
            ],

            // MAQUINARIA PESADA
            [
                'name' => 'Miniexcavadora',
                'category' => 'Maquinaria Pesada',
                'brand' => 'Varios',
                'description' => 'Miniexcavadora compacta para trabajos de excavación en espacios reducidos. Ideal para obras medianas y pequeñas.',
                'specs_json' => [
                    'Tipo' => 'Miniexcavadora',
                    'Aplicación' => 'Excavación',
                    'Tamaño' => 'Compacta',
                ],
                'applications_json' => [
                    'Excavación de zanjas',
                    'Movimiento de tierra',
                    'Preparación de terrenos',
                    'Trabajos de construcción',
                ],
            ],
            [
                'name' => 'Minicargador',
                'category' => 'Maquinaria Pesada',
                'brand' => 'Varios',
                'description' => 'Minicargador versátil para carga, descarga y movimiento de materiales. Ideal para espacios reducidos.',
                'specs_json' => [
                    'Tipo' => 'Minicargador',
                    'Aplicación' => 'Carga y movimiento',
                    'Tamaño' => 'Compacto',
                ],
                'applications_json' => [
                    'Carga de materiales',
                    'Movimiento de tierra',
                    'Trabajos en espacios reducidos',
                    'Construcción general',
                ],
            ],
            [
                'name' => 'Camión Tolva 3,5 y 4 m³',
                'category' => 'Maquinaria Pesada',
                'brand' => 'Varios',
                'description' => 'Camión tolva con capacidad de 3.5 y 4 metros cúbicos para transporte de materiales a granel. Arriendo por kilómetro según distancia.',
                'specs_json' => [
                    'Capacidad' => '3.5 y 4 m³',
                    'Tipo' => 'Camión tolva',
                    'Arriendo' => 'Por kilómetro',
                ],
                'applications_json' => [
                    'Transporte de materiales',
                    'Transporte de escombros',
                    'Movimiento de tierra',
                    'Obras de construcción',
                ],
            ],
            [
                'name' => 'Transporte de Maquinaria',
                'category' => 'Maquinaria Pesada',
                'brand' => 'Varios',
                'description' => 'Servicio de transporte especializado para maquinaria pesada. Arriendo por kilómetro según distancia del destino.',
                'specs_json' => [
                    'Tipo' => 'Transporte especializado',
                    'Arriendo' => 'Por kilómetro',
                    'Aplicación' => 'Transporte de maquinaria',
                ],
                'applications_json' => [
                    'Transporte de maquinaria pesada',
                    'Traslado de equipos',
                    'Servicio de logística',
                    'Movilización de maquinaria',
                ],
            ],

            // BOMBEO
            [
                'name' => 'Motobomba Bencinera con Manguera Succión 6 MT',
                'category' => 'Bombeo',
                'brand' => 'Varios',
                'description' => 'Motobomba bencinera con manguera de succión de 6 metros para bombeo de agua y líquidos. Ideal para desagües y riego.',
                'specs_json' => [
                    'Combustible' => 'Bencina',
                    'Manguera succión' => '6 metros',
                    'Tipo' => 'Motobomba',
                ],
                'applications_json' => [
                    'Bombeo de agua',
                    'Desagües',
                    'Riego',
                    'Extracción de líquidos',
                ],
            ],
            [
                'name' => 'Bomba Sumergible 220V 1½ Pulgadas con Manguera 5 MT',
                'category' => 'Bombeo',
                'brand' => 'Varios',
                'description' => 'Bomba sumergible eléctrica de 1½ pulgadas con manguera de 5 metros. Alimentación 220V para bombeo de agua.',
                'specs_json' => [
                    'Voltaje' => '220V',
                    'Diámetro' => '1½ pulgadas',
                    'Manguera' => '5 metros',
                    'Tipo' => 'Sumergible',
                ],
                'applications_json' => [
                    'Bombeo de agua desde pozos',
                    'Desagües profundos',
                    'Extracción de agua',
                    'Sistemas de riego',
                ],
            ],

            // JARDINERÍA
            [
                'name' => 'Desbrozadora/Desmalezadora a Combustión',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Desbrozadora a combustión para corte de maleza, pasto y vegetación. Ideal para mantenimiento de áreas verdes.',
                'specs_json' => [
                    'Combustible' => 'Bencina',
                    'Tipo' => 'Desbrozadora/Desmalezadora',
                    'Aplicación' => 'Corte de vegetación',
                ],
                'applications_json' => [
                    'Corte de maleza',
                    'Mantenimiento de áreas verdes',
                    'Limpieza de terrenos',
                    'Jardinería',
                ],
            ],
            [
                'name' => 'Cortacésped Bencinera 5 HP',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Cortacésped bencinero de 5 HP para corte de pasto y césped en áreas medianas y grandes.',
                'specs_json' => [
                    'Potencia' => '5 HP',
                    'Combustible' => 'Bencina',
                    'Tipo' => 'Cortacésped',
                ],
                'applications_json' => [
                    'Corte de césped',
                    'Mantenimiento de jardines',
                    'Corte de pasto',
                    'Jardinería',
                ],
            ],
            [
                'name' => 'Cortasetos Eléctrico 220V',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Cortasetos eléctrico de 220V para poda de setos y arbustos. Ligero y fácil de manejar.',
                'specs_json' => [
                    'Voltaje' => '220V',
                    'Tipo' => 'Eléctrico',
                    'Aplicación' => 'Poda de setos',
                ],
                'applications_json' => [
                    'Poda de setos',
                    'Mantenimiento de arbustos',
                    'Jardinería',
                    'Trabajos de poda',
                ],
            ],
            [
                'name' => 'Cortasetos Inalámbrico',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Cortasetos inalámbrico con batería recargable para poda de setos y arbustos. Sin cables, máxima movilidad.',
                'specs_json' => [
                    'Tipo' => 'Inalámbrico',
                    'Alimentación' => 'Batería',
                    'Aplicación' => 'Poda de setos',
                ],
                'applications_json' => [
                    'Poda de setos',
                    'Mantenimiento de arbustos',
                    'Jardinería',
                    'Trabajos de poda',
                ],
            ],
            [
                'name' => 'Cortasetos a Combustión',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Cortasetos a combustión para poda de setos y arbustos. Mayor potencia para trabajos exigentes.',
                'specs_json' => [
                    'Combustible' => 'Bencina',
                    'Tipo' => 'A combustión',
                    'Aplicación' => 'Poda de setos',
                ],
                'applications_json' => [
                    'Poda de setos',
                    'Mantenimiento de arbustos',
                    'Jardinería',
                    'Trabajos de poda intensivos',
                ],
            ],
            [
                'name' => 'Fumigadora de Espalda Manual',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Fumigadora manual de espalda para aplicación de productos fitosanitarios y fertilizantes en áreas verdes.',
                'specs_json' => [
                    'Tipo' => 'Manual',
                    'Uso' => 'Espalda',
                    'Aplicación' => 'Fumigación',
                ],
                'applications_json' => [
                    'Aplicación de fitosanitarios',
                    'Fertilización',
                    'Control de plagas',
                    'Mantenimiento de áreas verdes',
                ],
            ],
            [
                'name' => 'Barreno Ahoyador 52 CC con Brocas 100-150-200 MM',
                'category' => 'Jardinería',
                'brand' => 'Varios',
                'description' => 'Barreno ahoyador a combustión de 52 CC con brocas intercambiables de 100, 150 y 200 mm de diámetro para perforación de suelos.',
                'specs_json' => [
                    'Cilindrada' => '52 CC',
                    'Brocas' => '100-150-200 mm',
                    'Combustible' => 'Bencina',
                ],
                'applications_json' => [
                    'Perforación de suelos',
                    'Instalación de postes',
                    'Plantación de árboles',
                    'Trabajos de jardinería',
                ],
            ],

            // LIMPIEZA
            [
                'name' => 'Hidrolavadora de Alta Presión a Combustión',
                'category' => 'Limpieza',
                'brand' => 'Varios',
                'description' => 'Hidrolavadora de alta presión a combustión para limpieza profunda de superficies, maquinaria y equipos.',
                'specs_json' => [
                    'Tipo' => 'Alta presión',
                    'Combustible' => 'Bencina',
                    'Aplicación' => 'Limpieza profunda',
                ],
                'applications_json' => [
                    'Limpieza de maquinaria',
                    'Limpieza de superficies',
                    'Limpieza de equipos',
                    'Mantenimiento',
                ],
            ],
            [
                'name' => 'Abrillantadora de Piso Industrial 17"',
                'category' => 'Limpieza',
                'brand' => 'Varios',
                'description' => 'Abrillantadora de piso industrial con disco de 17 pulgadas para pulido y abrillantado de pisos de concreto y otros materiales.',
                'specs_json' => [
                    'Diámetro disco' => '17 pulgadas',
                    'Tipo' => 'Industrial',
                    'Aplicación' => 'Abrillantado',
                ],
                'applications_json' => [
                    'Pulido de pisos',
                    'Abrillantado de concreto',
                    'Mantenimiento de pisos',
                    'Acabados industriales',
                ],
            ],
            [
                'name' => 'Soplador de Aire Eléctrico',
                'category' => 'Limpieza',
                'brand' => 'Varios',
                'description' => 'Soplador de aire eléctrico para limpieza de áreas, eliminación de hojas y residuos ligeros.',
                'specs_json' => [
                    'Tipo' => 'Eléctrico',
                    'Aplicación' => 'Limpieza',
                    'Función' => 'Soplado',
                ],
                'applications_json' => [
                    'Limpieza de áreas',
                    'Eliminación de hojas',
                    'Limpieza de residuos',
                    'Mantenimiento',
                ],
            ],

            // HERRAMIENTAS Y CORTE
            [
                'name' => 'Tronzadora 14 Pulgadas para Metal',
                'category' => 'Herramientas',
                'brand' => 'Varios',
                'description' => 'Tronzadora de 14 pulgadas especializada para corte de metales. Ideal para trabajos de construcción y metalurgia.',
                'specs_json' => [
                    'Diámetro disco' => '14 pulgadas',
                    'Aplicación' => 'Corte de metal',
                    'Tipo' => 'Tronzadora',
                ],
                'applications_json' => [
                    'Corte de metales',
                    'Trabajos de construcción',
                    'Metalurgia',
                    'Corte de estructuras',
                ],
            ],
            [
                'name' => 'Cortadora de Pavimento con Disco Hormigón 18"',
                'category' => 'Herramientas',
                'brand' => 'Varios',
                'description' => 'Cortadora de pavimento con disco de 18 pulgadas especializado para corte de hormigón y concreto.',
                'specs_json' => [
                    'Diámetro disco' => '18 pulgadas',
                    'Aplicación' => 'Corte de hormigón',
                    'Tipo' => 'Cortadora de pavimento',
                ],
                'applications_json' => [
                    'Corte de pavimentos',
                    'Corte de hormigón',
                    'Demolición controlada',
                    'Trabajos de construcción',
                ],
            ],

            // ELÉCTRICOS Y GENERACIÓN
            [
                'name' => 'Generador Diésel 5 KVA Monofásico',
                'category' => 'Eléctricos',
                'brand' => 'Varios',
                'description' => 'Generador diésel de 5 KVA monofásico para suministro de energía eléctrica en obras y lugares sin conexión.',
                'specs_json' => [
                    'Potencia' => '5 KVA',
                    'Tipo' => 'Monofásico',
                    'Combustible' => 'Diésel',
                ],
                'applications_json' => [
                    'Suministro de energía',
                    'Obras sin conexión',
                    'Eventos temporales',
                    'Emergencias',
                ],
            ],
            [
                'name' => 'Compresor 50 LT',
                'category' => 'Eléctricos',
                'brand' => 'Varios',
                'description' => 'Compresor de aire de 50 litros para herramientas neumáticas y trabajos que requieren aire comprimido.',
                'specs_json' => [
                    'Capacidad' => '50 litros',
                    'Tipo' => 'Compresor',
                    'Aplicación' => 'Aire comprimido',
                ],
                'applications_json' => [
                    'Herramientas neumáticas',
                    'Pintura con pistola',
                    'Limpieza con aire',
                    'Trabajos generales',
                ],
            ],
            [
                'name' => 'Turbocalefactor a Combustión (Diésel/Parafina)',
                'category' => 'Eléctricos',
                'brand' => 'Varios',
                'description' => 'Turbocalefactor a combustión que funciona con diésel o parafina para calefacción de espacios grandes y obras.',
                'specs_json' => [
                    'Combustible' => 'Diésel/Parafina',
                    'Tipo' => 'Turbocalefactor',
                    'Aplicación' => 'Calefacción',
                ],
                'applications_json' => [
                    'Calefacción de espacios',
                    'Obras en invierno',
                    'Secado de superficies',
                    'Ambientación de áreas',
                ],
            ],
        ];

        // Eliminar máquinas existentes
        Machine::query()->delete();

        foreach ($machines as $machineData) {
            $slug = Str::slug($machineData['name']);
            
            Machine::create([
                'name' => $machineData['name'],
                'slug' => $slug,
                'category' => $machineData['category'],
                'brand' => $machineData['brand'],
                'description' => $machineData['description'],
                'specs_json' => $machineData['specs_json'],
                'applications_json' => $machineData['applications_json'],
                'gallery_json' => ['/storage/sampleMaquinaria.png'],
                'active' => true,
            ]);
        }
    }
}
