<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'builder_id',
        'title',
        'slug',
        'description',
        'year',
        'location',
        'gallery_json',
    ];

    protected function casts(): array
    {
        return [
            'gallery_json' => 'array',
            'year' => 'integer',
        ];
    }

    public function builder(): BelongsTo
    {
        return $this->belongsTo(Builder::class);
    }
}

