<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Machine extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'category',
        'brand',
        'description',
        'specs_json',
        'applications_json',
        'gallery_json',
        'active',
    ];

    protected function casts(): array
    {
        return [
            'specs_json' => 'array',
            'applications_json' => 'array',
            'gallery_json' => 'array',
            'active' => 'boolean',
        ];
    }

    public function quotations(): BelongsToMany
    {
        return $this->belongsToMany(Quotation::class)
            ->withPivot('quantity')
            ->withTimestamps();
    }
}

