<?php

namespace App\Http\Controllers;

use App\Models\Machine;
use Illuminate\Http\Request;
use Inertia\Inertia;

class MachineController extends Controller
{
    public function index(Request $request)
    {
        $query = Machine::where('active', true);

        // Filtros
        if ($request->has('category') && $request->category) {
            $query->where('category', $request->category);
        }

        if ($request->has('brand') && $request->brand) {
            $query->where('brand', $request->brand);
        }

        $machines = $query->orderBy('name')->paginate(12);

        // Obtener categorías con conteo de máquinas para el sidebar
        $categoriesWithCount = Machine::where('active', true)
            ->selectRaw('category, COUNT(*) as count')
            ->groupBy('category')
            ->orderBy('category')
            ->get()
            ->map(function ($item) {
                return [
                    'name' => $item->category,
                    'count' => $item->count,
                ];
            });

        // Obtener categorías y marcas únicas para los filtros
        $categories = Machine::where('active', true)
            ->distinct()
            ->pluck('category')
            ->filter()
            ->sort()
            ->values();

        $brands = Machine::where('active', true)
            ->distinct()
            ->pluck('brand')
            ->filter()
            ->sort()
            ->values();

        return Inertia::render('Machines/Index', [
            'machines' => $machines,
            'categoriesWithCount' => $categoriesWithCount,
            'categories' => $categories,
            'brands' => $brands,
            'filters' => [
                'category' => $request->category,
                'brand' => $request->brand,
            ],
        ]);
    }

    public function show(string $slug)
    {
        $machine = Machine::where('slug', $slug)
            ->where('active', true)
            ->firstOrFail();

        return Inertia::render('Machines/Show', [
            'machine' => $machine,
        ]);
    }
}
