<?php

namespace App\Http\Controllers;

use App\Models\Builder;
use Inertia\Inertia;

class BuilderController extends Controller
{
    public function index()
    {
        $builder = Builder::first();

        if (!$builder) {
            // Si no existe, crear uno por defecto con datos de ejemplo
            $builder = Builder::create([
                'name' => 'Constructora Akiyan',
                'slug' => 'constructora-akiyan',
                'description' => 'Constructora Akiyan es una empresa líder en el sector de la construcción en Chile, con más de 15 años de experiencia desarrollando proyectos de infraestructura, edificación y obras civiles de alta calidad. Nos especializamos en entregar soluciones constructivas integrales que combinan innovación, eficiencia y compromiso con la excelencia.',
                'history' => "Fundada en 2008, Constructora Akiyan nació con la visión de transformar el sector de la construcción en Chile mediante la aplicación de tecnologías modernas y metodologías eficientes.\n\nA lo largo de nuestros años de trayectoria, hemos completado más de 200 proyectos exitosos, desde pequeñas obras residenciales hasta grandes proyectos de infraestructura pública y privada. Nuestro crecimiento sostenido se debe a nuestro compromiso inquebrantable con la calidad, la seguridad y la satisfacción del cliente.\n\nEn 2015, expandimos nuestras operaciones para incluir servicios de arriendo de maquinaria pesada, convirtiéndonos en un proveedor integral de soluciones para la industria de la construcción.\n\nHoy, Constructora Akiyan es reconocida por su capacidad de ejecución, su equipo altamente calificado y su enfoque en la sostenibilidad y la innovación en cada proyecto que emprendemos.",
                'certifications_json' => [
                    'ISO 9001:2015 - Sistema de Gestión de Calidad',
                    'OHSAS 18001 - Sistema de Gestión de Seguridad y Salud Ocupacional',
                    'ISO 14001:2015 - Sistema de Gestión Ambiental',
                    'Certificación SEC - Superintendencia de Electricidad y Combustibles',
                    'Registro de Empresas Constructoras - Cámara Chilena de la Construcción',
                ],
                'logo' => '/storage/logoAkiyan.png',
            ]);
        }

        $projects = $builder->projects()
            ->orderBy('year', 'desc')
            ->orderBy('title')
            ->limit(4)
            ->get();

        return Inertia::render('Builder/Index', [
            'builder' => $builder,
            'projects' => $projects,
        ]);
    }
}
